/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.fluid;

import com.zurrtum.create.infrastructure.fluids.FluidInventory;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_11372;

public class FluidTank
implements FluidInventory {
    protected FluidStack fluid = FluidStack.EMPTY;
    protected Optional<Integer> max;
    protected int capacity;

    public FluidTank(int capacity) {
        this.max = Optional.of(capacity);
        this.capacity = capacity;
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != FluidStack.EMPTY) {
            this.setMaxSize(fluid, this.max);
        }
        this.fluid = fluid;
    }

    @Override
    public FluidStack onExtract(FluidStack stack) {
        return this.removeMaxSize(stack, this.max);
    }

    @Override
    public int getMaxAmountPerStack() {
        return this.capacity;
    }

    @Override
    public FluidStack getStack(int slot) {
        if (slot != 0) {
            return FluidStack.EMPTY;
        }
        return this.fluid;
    }

    @Override
    public void setStack(int slot, FluidStack stack) {
        if (slot == 0) {
            this.setFluid(stack);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public void read(class_11368 view) {
        this.fluid = view.method_71426("Fluid", FluidStack.CODEC).orElse(FluidStack.EMPTY);
        if (this.fluid.getAmount() > this.capacity) {
            this.fluid.setAmount(this.capacity);
        }
    }

    public void setCapacity(int capacity) {
        this.max = Optional.of(capacity);
        this.capacity = capacity;
        if (!this.fluid.isEmpty()) {
            this.setMaxSize(this.fluid, this.max);
        }
    }

    @Override
    public int size() {
        return 1;
    }

    public void write(class_11372 view) {
        if (!this.fluid.isEmpty()) {
            view.method_71468("Fluid", FluidStack.CODEC, (Object)this.fluid);
        }
    }
}

